$hotfixes = Get-Hotfix | Sort-Object -Descending InstalledOn -ErrorAction SilentlyContinue
if ($hotfixes.Count -ge 1) {
  $lastfixdate = $hotfixes[0].InstalledOn
} else {
  $lastfixdate = (Get-CimInstance -ClassName Win32_OperatingSystem).InstallDate
}
$today = Get-Date
return ($today - $lastfixdate).Days