$ret = 0
$regPath = "HKLM:\SYSTEM\CurrentControlSet\Control\SecurityProviders\SCHANNEL\Protocols"

$tlsVersions = @("TLS 1.0", "TLS 1.1")
foreach ($tls in $tlsVersions) {
    $clientKey = Join-Path -Path $regPath -ChildPath "$tls\Client"
    $serverKey = Join-Path -Path $regPath -ChildPath "$tls\Server"
   
    $clientEnabled = Get-ItemProperty -Path $clientKey -ErrorAction SilentlyContinue | Select-Object -ExpandProperty "Enabled" -ErrorAction SilentlyContinue
    $serverEnabled = Get-ItemProperty -Path $serverKey -ErrorAction SilentlyContinue | Select-Object -ExpandProperty "Enabled" -ErrorAction SilentlyContinue
    if ($clientEnabled -ne $null -and $clientEnabled -eq 1) {
      $ret++
    }
    if ($serverEnabled -ne $null -and $serverEnabled -eq 1) {
      $ret++
    }
}
return $ret