If ((Get-CimInstance -ClassName Win32_OperatingSystem).ProductType -eq "1") {
  If ((Get-WindowsOptionalFeature -Online -FeatureName Microsoft-Hyper-V).State -eq "Disabled") {
    return 0
  }
} else { 
  If (!(Get-WindowsFeature -Name Hyper-V).Installed) {
    return 0
  }
}


$vmversions = Get-VMHostSupportedVersion
foreach ($vmversion in $vmversions) {
  If ($vmversion.IsDefault) {
    $defaultvmver = ($vmversion.Version).Major, ($vmversion.Version).Minor -Join "."
  }
}
$ret = 0
$vmlist = Get-VM
foreach ($vm in $vmlist){
  If ($vm.Version -ne $defaultvmver) {
    $ret++
  }
}
return $ret